package ga.view.test.nifty;

import com.jme3.app.SimpleApplication;
import com.jme3.material.Material;
import com.jme3.niftygui.NiftyJmeDisplay;
import com.jme3.scene.Geometry;
import com.jme3.scene.shape.Box;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.builder.EffectBuilder;
import de.lessvoid.nifty.builder.HoverEffectBuilder;
import de.lessvoid.nifty.builder.ImageBuilder;
import de.lessvoid.nifty.builder.LayerBuilder;
import de.lessvoid.nifty.builder.PanelBuilder;
import de.lessvoid.nifty.builder.ScreenBuilder;
import de.lessvoid.nifty.builder.TextBuilder;
import de.lessvoid.nifty.effects.Falloff.HoverFalloffConstraint;
import de.lessvoid.nifty.effects.Falloff.HoverFalloffType;
import de.lessvoid.nifty.screen.DefaultScreenController;

public class NiftyTest extends SimpleApplication {

  @Override
  public void simpleInitApp() {
    final NiftyJmeDisplay niftyDisplay = new NiftyJmeDisplay(assetManager,
        inputManager, audioRenderer, guiViewPort);
    final Nifty nifty = niftyDisplay.getNifty();
    guiViewPort.addProcessor(niftyDisplay);
    flyCam.setDragToRotate(true);

    nifty.loadStyleFile("nifty-default-styles.xml");
    nifty.loadControlFile("nifty-default-controls.xml");
    // nifty.setDebugOptionPanelColors(true);

    final Geometry geo = new Geometry("box", new Box(1f, 1f, 1f));
    final Material mat = new Material(assetManager,
        "Common/MatDefs/Misc/Unshaded.j3md");

    geo.setMaterial(mat);

    rootNode.attachChild(geo);

    // <screen>
    nifty.addScreen("start", new ScreenBuilder("start") {
      {
        controller(new MyScreenController()); // Screen properties

        // <layer>

        layer(new LayerBuilder("Layer1") {
          {
            // childLayoutOverlay();
            //
            // panel(new PanelBuilder("Panel_Upper_Lower") {
            // {
            childLayoutVertical();

            panel(new PanelBuilder("Panel_Left") {
              {
                childLayoutHorizontal(); // layer properties, add more...

                // backgroundColor("#f008");

                // <panel>
                panel(new PanelBuilder("Panel_Text") {
                  {
                    childLayoutVertical();
                    padding("10px");

                    // GUI elements
                    // control(new ButtonBuilder("Button_ID", "Hello Nifty")
                    // {
                    // {
                    // alignCenter();
                    // valignCenter();
                    // height("5%");
                    // width("15%");
                    // }
                    // });

                    // backgroundColor("#00f8");

                    panel(new PanelBuilder("Panel_ID") {
                      {
                        childLayoutHorizontal();

                        // add text
                        text(new TextBuilder() {
                          {
                            text("Costs:");
                            font("Interface/Fonts/Default.fnt");

                            // x("1%");
                            // y("1%");
                            // height("100%");
                            // width("100%");

                          }
                        });

                        // add text
                        text(new TextBuilder() {
                          {

                            text("0");
                            font("Interface/Fonts/Default.fnt");

                            // x("100px");
                            // y("1%");
                            // height("100%");
                            // width("100%");
                          }
                        });

                      }
                    });

                    panel(new PanelBuilder("Panel_ID") {
                      {
                        childLayoutHorizontal();
                        // add text
                        text(new TextBuilder() {
                          {
                            text("Fitness:");
                            font("Interface/Fonts/Default.fnt");
                            // x("1%");
                            // y("1%");
                            // height("100%");
                            // width("100%");
                          }
                        });

                        // add text
                        text(new TextBuilder() {
                          {
                            text("0");
                            font("Interface/Fonts/Default.fnt");
                            // x("100px");
                            // y("1%");
                            // height("100%");
                            // width("100%");
                          }
                        });

                      }
                    });

                    // .. add more GUI elements here

                  }
                });

                panel(new PanelBuilder("Panel_Right") {
                  {
                    childLayoutCenter();
                    valignCenter();

                    padding("10px");

                    height("100%");

                    panel(new PanelBuilder("Panel_FitnessChange") {
                      {
                        childLayoutVertical();
                        width("100px");

                        image(new ImageBuilder() {
                          {
                            filename("ga/view/test/nifty/plus2.png");
                            alignLeft();
                            valignCenter();
                            visibleToMouse();

                            interactOnClick("onFitnessChange(2)");

                            onClickEffect(new EffectBuilder("imageOverlay") {
                              {
                                post(true);
                                effectParameter("filename",
                                    "ga/view/test/nifty/next-click.png");
                                length(150);
                              }
                            });

                            onHoverEffect(new HoverEffectBuilder("imageOverlay") {
                              {
                                post(true);
                                effectParameter("filename",
                                    "ga/view/test/nifty/hover.png");

                                hoverFalloffType(HoverFalloffType.linear);
                                hoverFalloffConstraint(HoverFalloffConstraint.horizontal);
                                hoverWidth("120%");
                                hoverHeight("100%");
                              }
                            });
                          }
                        });
                        //

                        image(new ImageBuilder() {
                          {
                            filename("ga/view/test/nifty/plus.png");
                            alignLeft();
                            valignCenter();
                            visibleToMouse();

                            interactOnClick("onFitnessChange(1)");

                            onClickEffect(new EffectBuilder("imageOverlay") {
                              {
                                post(true);
                                effectParameter("filename",
                                    "ga/view/test/nifty/next-click.png");
                                length(150);
                              }
                            });

                            onHoverEffect(new HoverEffectBuilder("imageOverlay") {
                              {
                                post(true);
                                effectParameter("filename",
                                    "ga/view/test/nifty/hover.png");

                                hoverFalloffType(HoverFalloffType.linear);
                                hoverFalloffConstraint(HoverFalloffConstraint.horizontal);
                                hoverWidth("120%");
                                hoverHeight("100%");
                              }
                            });
                          }
                        });
                        //

                        image(new ImageBuilder() {
                          {
                            filename("ga/view/test/nifty/zero.png");
                            alignLeft();
                            valignCenter();
                            visibleToMouse();

                            interactOnClick("onFitnessChange(0)");

                            onClickEffect(new EffectBuilder("imageOverlay") {
                              {
                                post(true);
                                effectParameter("filename",
                                    "ga/view/test/nifty/next-click.png");
                                length(150);
                              }
                            });

                            onHoverEffect(new HoverEffectBuilder("imageOverlay") {
                              {
                                post(true);
                                effectParameter("filename",
                                    "ga/view/test/nifty/hover.png");

                                hoverFalloffType(HoverFalloffType.linear);
                                hoverFalloffConstraint(HoverFalloffConstraint.horizontal);
                                hoverWidth("120%");
                                hoverHeight("100%");
                              }
                            });
                          }
                        });
                        //

                        image(new ImageBuilder() {
                          {
                            filename("ga/view/test/nifty/minus.png");
                            alignLeft();
                            valignCenter();
                            visibleToMouse();

                            interactOnClick("onFitnessChange(-1)");

                            onClickEffect(new EffectBuilder("imageOverlay") {
                              {
                                post(true);
                                effectParameter("filename",
                                    "ga/view/test/nifty/next-click.png");
                                length(150);
                              }
                            });

                            onHoverEffect(new HoverEffectBuilder("imageOverlay") {
                              {
                                post(true);
                                effectParameter("filename",
                                    "ga/view/test/nifty/hover.png");

                                hoverFalloffType(HoverFalloffType.linear);
                                hoverFalloffConstraint(HoverFalloffConstraint.horizontal);
                                hoverWidth("120%");
                                hoverHeight("100%");
                              }
                            });
                          }
                        });
                        //

                        image(new ImageBuilder() {
                          {
                            filename("ga/view/test/nifty/minus2.png");
                            alignLeft();
                            valignCenter();
                            visibleToMouse();

                            interactOnClick("onFitnessChange(-2)");

                            onClickEffect(new EffectBuilder("imageOverlay") {
                              {
                                post(true);
                                effectParameter("filename",
                                    "ga/view/test/nifty/next-click.png");
                                length(150);
                              }
                            });

                            onHoverEffect(new HoverEffectBuilder("imageOverlay") {
                              {
                                post(true);
                                effectParameter("filename",
                                    "ga/view/test/nifty/hover.png");

                                hoverFalloffType(HoverFalloffType.linear);
                                hoverFalloffConstraint(HoverFalloffConstraint.horizontal);
                                hoverWidth("120%");
                                hoverHeight("100%");
                              }
                            });
                          }
                        });
                        //
                      }
                    });
                  }
                });

                // </panel>
              }
            });

          }
        });

        layer(new LayerBuilder("Layer2") {
          {
            childLayoutCenter();

            panel(new PanelBuilder("Panel_Lower") {
              {
                childLayoutVertical();
                valignBottom();

                width("368px");

                alignCenter();

                panel(new PanelBuilder("Panel_Rotate") {
                  {
                    childLayoutHorizontal();
                    alignCenter();

                    image(new ImageBuilder() {
                      {
                        filename("ga/view/test/nifty/rotation_left.png");

                        visibleToMouse();

                        interactOnClick("rotateLeft()");

                        // onClickEffect(new EffectBuilder("imageOverlay") {
                        // {
                        // post(true);
                        // effectParameter("filename",
                        // "ga/view/test/nifty/next-click.png");
                        // length(150);
                        // }
                        // });
                        //
                        // onHoverEffect(new HoverEffectBuilder("imageOverlay")
                        // {
                        // {
                        // post(true);
                        // effectParameter("filename",
                        // "ga/view/test/nifty/hover.png");
                        //
                        // hoverFalloffType(HoverFalloffType.linear);
                        // hoverFalloffConstraint(HoverFalloffConstraint.horizontal);
                        // hoverWidth("120%");
                        // hoverHeight("100%");
                        // }
                        // });
                      }
                    });
                    //

                    panel(new PanelBuilder("Panel_Up_Down") {
                      {
                        childLayoutVertical();

                        image(new ImageBuilder() {
                          {
                            filename("ga/view/test/nifty/rotation_up.png");
                            visibleToMouse();
                            alignCenter();

                            interactOnClick("rotateUp()");

                            // onClickEffect(new EffectBuilder("imageOverlay") {
                            // {
                            // post(true);
                            // effectParameter("filename",
                            // "ga/view/test/nifty/next-click.png");
                            // length(150);
                            // }
                            // });
                            //
                            // onHoverEffect(new
                            // HoverEffectBuilder("imageOverlay")
                            // {
                            // {
                            // post(true);
                            // effectParameter("filename",
                            // "ga/view/test/nifty/hover.png");
                            //
                            // hoverFalloffType(HoverFalloffType.linear);
                            // hoverFalloffConstraint(HoverFalloffConstraint.horizontal);
                            // hoverWidth("120%");
                            // hoverHeight("100%");
                            // }
                            // });
                          }
                        });

                        image(new ImageBuilder() {
                          {
                            filename("ga/view/test/nifty/rotation_down.png");
                            visibleToMouse();
                            alignCenter();

                            interactOnClick("rotateDown()");

                            // onClickEffect(new EffectBuilder("imageOverlay") {
                            // {
                            // post(true);
                            // effectParameter("filename",
                            // "ga/view/test/nifty/next-click.png");
                            // length(150);
                            // }
                            // });
                            //
                            // onHoverEffect(new
                            // HoverEffectBuilder("imageOverlay")
                            // {
                            // {
                            // post(true);
                            // effectParameter("filename",
                            // "ga/view/test/nifty/hover.png");
                            //
                            // hoverFalloffType(HoverFalloffType.linear);
                            // hoverFalloffConstraint(HoverFalloffConstraint.horizontal);
                            // hoverWidth("120%");
                            // hoverHeight("100%");
                            // }
                            // });
                          }
                        });

                      }
                    });

                    image(new ImageBuilder() {
                      {
                        filename("ga/view/test/nifty/rotation_right.png");
                        visibleToMouse();

                        interactOnClick("rotateRight()");

                        // onClickEffect(new EffectBuilder("imageOverlay") {
                        // {
                        // post(true);
                        // effectParameter("filename",
                        // "ga/view/test/nifty/next-click.png");
                        // length(150);
                        // }
                        // });
                        //
                        // onHoverEffect(new HoverEffectBuilder("imageOverlay")
                        // {
                        // {
                        // post(true);
                        // effectParameter("filename",
                        // "ga/view/test/nifty/hover.png");
                        //
                        // hoverFalloffType(HoverFalloffType.linear);
                        // hoverFalloffConstraint(HoverFalloffConstraint.horizontal);
                        // hoverWidth("120%");
                        // hoverHeight("100%");
                        // }
                        // });
                      }
                    });

                  }
                });
              }
            });

          }
        });

        // panel(new PanelBuilder("Panel_ID1") {
        // {
        // childLayoutCenter();
        // // alignCenter();
        //
        // padding("10px");
        //
        // width("100%");

        // }
        // });

        // </layer>
      }
    }.build(nifty));
    // </screen>

    nifty.gotoScreen("start"); // start the screen
  }

  public class MyScreenController extends DefaultScreenController {

    public void onFitnessChange(final String s) {
      final Integer change = Integer.valueOf(s);
      System.out.println("Fitness " + (change > 0 ? "+" : "") + change);
    }

  }

  public static void main(final String[] args) {
    new NiftyTest().start();
  }
}
